-- MOD for DCS WORLD 
-- Ship PLAN China Classe TYPE-054A HANDAN,  by Markindel (www.news3d.eu)

-----             Cartella Shapes --------------------------------------------------
mount_vfs_model_path	(current_mod_path.."/Shapes/")

-----             Cartella Textures ---------------------------------------------------
mount_vfs_texture_path  (current_mod_path.."/Textures/")
mount_vfs_texture_path  (current_mod_path.."/Textures/TYPE-054A_HANDAN.zip")



GT = {};
GT_t.ws = 0;

set_recursive_metatable(GT, GT_t.generic_ship)

GT.visual = {}
GT.visual.shape = "TYPE-054A_HANDAN"
GT.visual.shape_dstr = ""

GT.animation_arguments.radar1_rotation = 11; --   1
GT.radar1_period = 3;
GT.animation_arguments.radar2_rotation = -1; --   2 
GT.animation_arguments.radar3_rotation = -1; --   3 
GT.animation_arguments.luna_lights = -1;


GT.life = 2700;
GT.mass = 9.59e+006;
GT.max_velocity = 15.4333
GT.race_velocity = 15.4333
GT.economy_velocity = 10.2889
GT.economy_distance = 1.1112e+007
GT.race_distance = 2.778e+006
GT.shipLength = 172.8
GT.Width = 15
GT.Height = 37.2
GT.Length = 172.8
GT.DeckLevel = 8
-----GT.X_nose = 75.7412
GT.X_nose = 63.0
GT.X_tail = -70
GT.Tail_Width = 15
GT.Gamma_max = 0.35
GT.Om = 0.05
GT.speedup = 0.229734
GT.R_min = 345.6
GT.distFindObstacles = 568.4

GT.numParking = 1
GT.Plane_Num_ = 0
GT.Helicopter_Num_ = 2

GT.airWeaponDist = 100000
GT.airFindDist = 150000

---- Primo valore    : avanti/indietro
---- Secondo valore: alto/basso
---- Terzo Valore    : destra/sinistra

---GT.Landing_Point = {-44.0, 9.93, 0.0}  ---- Valori Originali Ticonderoga
---GT.Landing_Point = {-55.0, 6.5, 0.0}  ----
GT.Landing_Point = {-60.0, 6.3, 0.0}  ----


GT.DM = {
    { area_name = "NOSE_R",			                area_arg = 70,	area_life = 110, area_fire = { pos = {57.0, 4.0, 5.0}, size = 0.8}},
    { area_name = "BORT_R",			                area_arg = 71,	area_life = 110, area_fire = { pos = {1.0,  1.0, 5.0}, size = 0.8}},
    { area_name = "KORMA_R", 		                area_arg = 72,	area_life = 110, area_fire = { pos = {-70.0, 2.0, 7.7}, size = 0.8}},
    { area_name = "NOSE_L", 		                    area_arg = 73,	area_life = 110, area_fire = { pos = {50.0, 4.0, -5.0}, size = 0.8}},
    { area_name = "BORT_L", 		                    area_arg = 74,	area_life = 110, area_fire = { pos = {0.0,  2.0, -8.0}, size = 0.8}},
    { area_name = "KORMA_L", 		                area_arg = 75,	area_life = 110, area_fire = { pos = {-70.0, 2.0, -7.7}, size = 0.8}},
    { area_name = "KORMA_L", 		                area_arg = 75,	area_life = 110, area_fire = { pos = {-72.0, 2.0, 0.0}, size = 0.8}},
	{ area_name = "KORMA_L", 		                area_arg = 75,	area_life = 110, area_fire = { pos = {-60.0, 2.0, 0.0}, size = 0.8}},
	{ area_name = "NOSE_TOP",		                area_arg = 76,	area_life = 80,  area_fire = { pos = {41.5, 7.5, 0.0}, size = 0.5}},
	{ area_name = "RUBKA_TOP",		            area_arg = 77,	area_life = 100, area_fire = { pos = {7.0,  20.0, 0.0}, size = 0.8}},
	{ area_name = "HP",				                    area_arg = 78,	area_life = 80,  area_fire = { pos = {-40.0, 7.6, 0.0}, size = 0.5}},
	{ area_name = "KORMA_BACK", 	            area_arg = 79,	area_life = 110, area_fire = { pos = {-85.7, 2.0, 0.0}, size = 0.5}},
	{ area_name = "KABINA",			                area_arg = 80,	area_life = 220, area_fire = { pos = {20.8, 18.0   , 0.0}, size = 1.5}},
	{ area_name = "BORT_TOP_BACK", 	        area_arg = 81,	area_life = 80,  area_fire = { pos = {-61.7, 5.9, 0.0}, size = 0.5}},
	{ area_name = "NADSTROYKA",		        area_arg = 82,	area_life = 220, area_fire = { pos = {-23.0, 12.0, 0.0}, size = 1.5}},
	{ area_name = "SUPERSTRUCTURE_Mid",	area_arg = 83,	area_life = 320, area_fire = { pos = {5.6, 9.8, 0.0}, size = 1.5}},
	{ area_name = "KORMA_TOP", 		            area_arg = 84,	area_life = 40, area_fire = { pos = {-76.7, 3.4, 0.0}, size = 1.0}},
    { area_name = "TOWER_NOSE",		        area_arg = 97,	area_life = 60, area_fire = { pos = {55.2, 8.2, 0.0}, size = 0.5}},
	{ area_name = "TOWER_KORMA",          	area_arg = 98,	area_life = 60, area_fire = { pos = {-49.0, 3.5, 0.0}, size = 0.5}},
    { area_name = "ZA_R",			                    area_arg = 99,	area_life = 27, area_fire = { pos = {3.7, 17.15, 6.25}, size = 0.5}},
    { area_name = "ZA_L",			                    area_arg = 100,	area_life = 27, area_fire = { pos = {30.0,  12.0, 0.0}, size = 0.5}}, --- CIWS Prua
}

-- weapon systems
GT.WS = {}
local ws;
GT.WS.maxTargetDetectionRange = 450000;
GT.WS.radar_type = 102


-- CIWS 
--------------   CIWS Left -----------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].area = 'ZA_L'
GT.WS[ws].center = 'CENTER_TOWER_04'
GT.WS[ws].drawArgument1 = 36
GT.WS[ws].drawArgument2 = 37
GT.WS[ws].angles[1][1] = math.rad(177);
GT.WS[ws].angles[1][2] = math.rad(3);

GT.WS[ws].angles[1][3] = math.rad(-5);
GT.WS[ws].angles[1][4] = math.rad(85);
GT.WS[ws].LN[1].fireAnimationArgument = 119;
GT.WS[ws].LN[1].BR[1].connector_name =  'POINT_GUN_02'

--------------   CIWS Right -----------------------------------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.phalanx )
GT.WS[ws].area = 'ZA_R'
GT.WS[ws].center = 'CENTER_TOWER_013'
GT.WS[ws].drawArgument1 = 25
GT.WS[ws].drawArgument2 = 26
GT.WS[ws].angles[1][1] = math.rad(-3);
GT.WS[ws].angles[1][2] = math.rad(-170);

GT.WS[ws].angles[1][3] = math.rad(-5);
GT.WS[ws].angles[1][4] = math.rad(85);
GT.WS[ws].LN[1].fireAnimationArgument = 118;
GT.WS[ws].LN[1].BR[1].connector_name =  'POINT_GUN_03'

---------------------------------------------------------------------------------------------------------------------------------------------------------
-- Artillery Guns
--------------  classe Spruance: Torretta Cannone di prua 
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_FMC5 )
GT.WS[ws].area = 'TOWER_NOSE'
GT.WS[ws].center = 'CENTER_TOWER_12'
GT.WS[ws].drawArgument1 = 0
GT.WS[ws].drawArgument2 = 1
GT.WS[ws].angles[1][1] = math.rad(170);
GT.WS[ws].angles[1][2] = math.rad(-170);
GT.WS[ws].LN[1].BR[1].connector_name = 'Point_Gun_01'
GT.WS[ws].LN[1].BR[1].recoilArgument = 33;
GT.WS[ws].LN[1].BR[1].recoilTime = 0.2;
----------------------------------------------------------------------------------------------------------------------------------------
-- Harpoon
----------------   tubi di lancio dei missili Harpoon  ---------------------------------------------------
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_HARPOON )
GT.WS[ws].area = 'RUBKA_TOP';
GT.WS[ws].pos = {-83.594,7.002,-4.54}
GT.WS[ws].angles[1][1] = math.rad(180);
GT.WS[ws].angles[1][2] = math.rad(0);
GT.WS[ws].LN[1].PL[1].ammo_capacity = 4;
GT.WS[ws].LN[1].PL[1].type_ammunition = {4,4,8,55};
GT.WS[ws].LN[1].PL[1].name_ammunition = "_35";
GT.WS[ws].LN[1].BR = {
		{connector_name = 'Rocket_Point_123', drawArgument = 153},
		{connector_name = 'Rocket_Point_124', drawArgument = 154},
		{connector_name = 'Rocket_Point_125', drawArgument = 155},
		{connector_name = 'Rocket_Point_126', drawArgument = 156},
}
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_HARPOON )
GT.WS[ws].area = 'RUBKA_TOP';
GT.WS[ws].pos = {-85.594,7.002,-4.54}
GT.WS[ws].angles[1][1] = math.rad(0);
GT.WS[ws].angles[1][2] = math.rad(-180);
GT.WS[ws].LN[1].PL[1].ammo_capacity = 4;
GT.WS[ws].LN[1].PL[1].type_ammunition = {4,4,8,55};
GT.WS[ws].LN[1].PL[1].name_ammunition = "_35";
GT.WS[ws].LN[1].BR = {
		{connector_name = 'Rocket_Point_127', drawArgument = 157},
		{connector_name = 'Rocket_Point_128', drawArgument = 158},
		{connector_name = 'Rocket_Point_129', drawArgument = 159},
		{connector_name = 'Rocket_Point_130', drawArgument = 160},
}



-- 9 AIGES trackers
ws = GT_t.inc_ws();
local first_EGES_tracker_id = ws;
GT.WS[ws] = {
	omegaY = 2,
	omegaZ = 2,
	pidY = {p=100, i=0.05, d=12, inn = 50},
	pidZ = {p=100, i=0.05, d=12, inn = 50},
	area = 'KABINA',
	pos = {0.0, 19.0, 0.0},
	angles = { {math.rad(180), math.rad(-180), math.rad(-90), math.rad(80)} },
	LN = {
		[1] = {
			type = 102,
			distanceMin = 1000,
			distanceMax = 150000,
			reactionTime = 2.0,
			reflection_limit = 0.1,
			ECM_K = 0.5,
			min_trg_alt = 5,
			max_trg_alt = 30000,
			max_number_of_missiles_channels = 2
		}
	}
};
local AIGES_TRACKERS = {{{'self', ws}}}

for i=2,9 do
	ws = GT_t.inc_ws();
	GT.WS[ws] = {};
	set_recursive_metatable(GT.WS[ws], GT.WS[first_EGES_tracker_id]);
	table.insert(AIGES_TRACKERS, {{'self', ws}})
end;


---------------   Sistema Missilistico VLS di PRUA -------------------------------------------------
--SM2 SAM
ws = GT_t.inc_ws();
GT.WS[ws] = {}
set_recursive_metatable(GT.WS[ws], GT_t.WS_t.ship_MK41_SM2 )
GT.WS[ws].area = 'NOSE_TOP'
GT.WS[ws].center = 'Rocket_Point_36'
GT.WS[ws].LN[1].depends_on_unit = AIGES_TRACKERS
GT.WS[ws].LN[1].ECM_K = 0.65;
GT.WS[ws].LN[1].PL[1].ammo_capacity = 61;
GT.WS[ws].LN[1].PL[1].type_ammunition = {4,4,34,87};
GT.WS[ws].LN[1].PL[1].name_ammunition = "9M38"
GT.WS[ws].LN[1].BR = {
	{connector_name = 'Rocket_Point_01', drawArgument = 188},
	{connector_name = 'Rocket_Point_02', drawArgument = 189},
	{connector_name = 'Rocket_Point_03', drawArgument = 190},
	{connector_name = 'Rocket_Point_04', drawArgument = 191},
	{connector_name = 'Rocket_Point_05', drawArgument = 192},
	{connector_name = 'Rocket_Point_06', drawArgument = 193},
	{connector_name = 'Rocket_Point_07', drawArgument = 194},
	{connector_name = 'Rocket_Point_08', drawArgument = 195},
	
	{connector_name = 'Rocket_Point_09', drawArgument = 196},
	{connector_name = 'Rocket_Point_10', drawArgument = 197},
	{connector_name = 'Rocket_Point_11', drawArgument = 198},
	{connector_name = 'Rocket_Point_12', drawArgument = 199},
	{connector_name = 'Rocket_Point_13', drawArgument = 200},
	{connector_name = 'Rocket_Point_14', drawArgument = 201},
	{connector_name = 'Rocket_Point_15', drawArgument = 202},
	{connector_name = 'Rocket_Point_16', drawArgument = 203},
	
	{connector_name = 'Rocket_Point_17', drawArgument = 204},
	{connector_name = 'Rocket_Point_18', drawArgument = 205},
	{connector_name = 'Rocket_Point_19', drawArgument = 206},
	{connector_name = 'Rocket_Point_20', drawArgument = 207},
	{connector_name = 'Rocket_Point_21', drawArgument = 208},
	{connector_name = 'Rocket_Point_22', drawArgument = 209},
	{connector_name = 'Rocket_Point_23', drawArgument = 210},
	{connector_name = 'Rocket_Point_24', drawArgument = 211},
	
	{connector_name = 'Rocket_Point_25', drawArgument = 212},
	{connector_name = 'Rocket_Point_26', drawArgument = 213},
	{connector_name = 'Rocket_Point_27', drawArgument = 214},
	{connector_name = 'Rocket_Point_28', drawArgument = 215},
	{connector_name = 'Rocket_Point_29', drawArgument = 216},
	{connector_name = 'Rocket_Point_30', drawArgument = 217},
	{connector_name = 'Rocket_Point_31', drawArgument = 218},
	{connector_name = 'Rocket_Point_32', drawArgument = 219},
}

--------------------------------------------------------------------------------------------------------------------------------------------------------------

GT.Name = "TYPE-054A_HANDAN"
GT.DisplayName = _("PLAN TYPE-054A_HANDAN")
GT.Rate = 4000

GT.Sensors = {  OPTIC = {"long-range naval optics", "long-range naval LLTV", "long-range naval FLIR",},
                RADAR = {
                    "Patriot str",
                    "ticonderoga search radar",
				    "seasparrow tr",
                }
            };

GT.DetectionRange  = GT.airFindDist;
GT.ThreatRange = GT.airWeaponDist;
GT.Singleton   ="no";
GT.mapclasskey = "P0091000067";
---GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip, TICONDEROGA,  --------- PERRY
--GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip, PERRY,  --------- TICONDEROGA
GT.attribute = {wsType_Navy,wsType_Ship,wsType_ArmedShip,wsType_GenericLightArmoredShip,

                    "Cruisers",
                    "RADAR_BAND1_FOR_ARM",
                    "DetectionByAWACS",
				};
GT.Categories = {
					{name = "Armed Ship"},
					{name = "HelicopterCarrier"}
						};
				
add_surface_unit(GT)				